const express = require("express");
const app = express();
const bodyParser = require("body-parser");
const path = require("path");
const cookieParser = require("cookie-parser");

require("./db");

const authValidator = require("./middleware/authValidator");

app.use(bodyParser.urlencoded({ extended: false }));
app.use(bodyParser.json());
app.use(cookieParser());
app.use(authValidator());

app.set("view engine", "ejs");
app.use("/", express.static(__dirname + "/views"));

const PORT = process.env.PORT || 6871;

app.use("/api", require("./controller/apiHandler"));

app.use("/", (req, res) => {
  const filePath = path.resolve(__dirname, "views", "index.html");
  res.sendFile(filePath);
});

// const addUrl = () => {
//     Product.find().then((products) => {
//         products.forEach((product) => {
//             if (!product.url) {
//                 product.url = generateUrl(product.title);
//                 product.save();
//                 console.log('product', product);
//             }
//         });
//     });
// }

// (async()=>{
//     const letters = await Letter.find({ letter: 'Hearts' })
//     for (let index = 0; index < letters.length; index++) {
//         const element = letters[index];
//         const cur = Letter.findByIdAndUpdate(element._id, {
//             letter: 'Heart'
//         })
//     }
// })()

app.listen(PORT, () => {
  console.log(`App is live on: http://localhost:${PORT}`);
});
